###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kerio_mailserver_mult_xss_vuln.nasl 800 2009-01-06 11:54:58Z jan $
#
# Kerio Mail Server Multiple Cross Site Scripting vulnerabilities
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800099);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5760", "CVE-2008-5769");
  script_bugtraq_id(32863);
  script_name(english:"Kerio Mail Server Multiple Cross Site Scripting vulnerabilities");
  desc["english"] = "

  Overview: The host is running Kerio Mail Server and is prone to multiple
  cross site scripting vulnerabilities.

  Vulnerability Insight:
  Issues are due to,
  - a folder and daytime parameters in mailCompose.php and calendarEdit.php
    files is not properly sanitised before being returned to the user.
  - input passed to the sent parameter in error413.php is not properly
    sanitised before being returned to the user.

  Impact:
  Successful exploitation could result in insertion of arbitrary HTML and
  script code in a user's browser session in the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Kerio MailServer before 6.6.2 on all running platform.

  Fix: Upgrade to Kerio MailServer 6.6.2
  http://www.kerio.com/kms_download.html

  References:
  http://secunia.com/advisories/32955
  http://xforce.iss.net/xforce/xfdb/47398

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Kerio Mail Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_kerio_mailserver_detect.nasl");
  script_require_keys("KerioMailServer/Ver");
  exit(0);
}


include("version_func.inc");

kerioVer = get_kb_item("KerioMailServer/Ver");
if(!kerioVer){
  exit(0);
}

if(version_is_less(version:kerioVer, test_version:"6.6.2")){
  security_warning(0);
}
