###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for wvstreams MDKA-2007:010 (wvstreams)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830040);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:010");
  script_cve_id("");
  script_name(english: "Mandriva Update for wvstreams MDKA-2007:010 (wvstreams)");
  desc["english"] = "

  Vulnerability Insight:

  In Mandriva 2007.0, the wvstreams package was built with openssl 0.9.7,
  which was not available in the final 2007.0 release. This made the
  wvstreams package impossible to install on Mandriva 2007.0 (bug 26240).
  This update is built with openssl 0.9.8, so that it can be installed on
  a Mandriva 2007.0 system.

  Affected Software/OS:
  wvstreams on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00022.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wvstreams");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libwvstreams3.74", rpm:"libwvstreams3.74~3.74.0~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwvstreams3.74-devel", rpm:"libwvstreams3.74-devel~3.74.0~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wvstreams", rpm:"wvstreams~3.74.0~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wvstreams3.74", rpm:"lib64wvstreams3.74~3.74.0~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wvstreams3.74-devel", rpm:"lib64wvstreams3.74-devel~3.74.0~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}