###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xine-ui MDKSA-2007:027 (xine-ui)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830089);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:027");
  script_cve_id("CVE-2007-0254", "CVE-2007-0017", "CVE-2007-0255");
  script_name(english: "Mandriva Update for xine-ui MDKSA-2007:027 (xine-ui)");
  desc["english"] = "

  Vulnerability Insight:

  Format string vulnerability in the errors_create_window function in
  errors.c in xine-ui allows attackers to execute arbitrary code via
  unknown vectors. (CVE-2007-0254)
  
  XINE 0.99.4 allows user-assisted remote attackers to cause a denial of
  service (application crash) and possibly execute arbitrary code via a
  certain M3U file that contains a long #EXTINF line and contains format
  string specifiers in an invalid udp:// URI, possibly a variant of
  CVE-2007-0017. (CVE-2007-0255)
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  xine-ui on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00041.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xine-ui");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"xine-ui", rpm:"xine-ui~0.99.4~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui-aa", rpm:"xine-ui-aa~0.99.4~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui-fb", rpm:"xine-ui-fb~0.99.4~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}