###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ImageMagick MDKSA-2007:041 (ImageMagick)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830341);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:041");
  script_cve_id("CVE-2006-5456", "CVE-2007-0770");
  script_name(english: "Mandriva Update for ImageMagick MDKSA-2007:041 (ImageMagick)");
  desc["english"] = "

  Vulnerability Insight:

  Vladimir Nadvornik discovered a buffer overflow in GraphicsMagick and
  ImageMagick allows user-assisted attackers to cause a denial of service
  and possibly execute execute arbitrary code via a PALM image that is
  not properly handled by the ReadPALMImage function in coders/palm.c.
  
  This is related to an earlier fix for CVE-2006-5456 that did not fully
  correct the issue.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  ImageMagick on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00011.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-doc", rpm:"ImageMagick-doc~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.4.0", rpm:"libMagick10.4.0~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.4.0-devel", rpm:"libMagick10.4.0-devel~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Image-Magick", rpm:"perl-Image-Magick~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.4.0", rpm:"lib64Magick10.4.0~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.4.0-devel", rpm:"lib64Magick10.4.0-devel~6.2.9.2~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-doc", rpm:"ImageMagick-doc~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick8.4.2", rpm:"libMagick8.4.2~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick8.4.2-devel", rpm:"libMagick8.4.2-devel~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Image-Magick", rpm:"perl-Image-Magick~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick8.4.2", rpm:"lib64Magick8.4.2~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick8.4.2-devel", rpm:"lib64Magick8.4.2-devel~6.2.4.3~1.5.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}