###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDKSA-2007:078 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830108);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:078");
  script_cve_id("CVE-2006-6056", "CVE-2007-0005", "CVE-2007-0772", "CVE-2004-1073", "CVE-2007-0958", "CVE-2007-1000", "CVE-2007-1217", "CVE-2007-1388", "CVE-2007-1592");
  script_name(english: "Mandriva Update for kernel MDKSA-2007:078 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  Some vulnerabilities were discovered and corrected in the Linux
  2.6 kernel:
  
  When SELinux hooks are enabled, the kernel could allow a local user
  to cause a DoS (crash) via a malformed file stream that triggers a
  NULL pointer derefernece (CVE-2006-6056).
  
  Multiple buffer overflows in the (1) read and (2) write handlers in
  the Omnikey CardMan 4040 driver in the Linux kernel before 2.6.21-rc3
  allow local users to gain privileges. (CVE-2007-0005)
  
  The Linux kernel version 2.6.13 to 2.6.20.1 allowed a remote attacker to
  cause a DoS (oops) via a crafted NFSACL2 ACCESS request that triggered
  a free of an incorrect pointer (CVE-2007-0772).
  
  A local user could read unreadable binaries by using the interpreter
  (PT_INTERP) functionality and triggering a core dump; a variant of
  CVE-2004-1073 (CVE-2007-0958).
  
  The ipv6_getsockopt_sticky function in net/ipv6/ipv6_sockglue.c in the
  Linux kernel before 2.6.20.2 allows local users to read arbitrary
  kernel memory via certain getsockopt calls that trigger a NULL
  dereference. (CVE-2007-1000)
  
  Buffer overflow in the bufprint function in capiutil.c in libcapi,
  as used in Linux kernel 2.6.9 to 2.6.20 and isdn4k-utils, allows local
  users to cause a denial of service (crash) and possibly gain privileges
  via a crafted CAPI packet. (CVE-2007-1217)
  
  The do_ipv6_setsockopt function in net/ipv6/ipv6_sockglue.c in Linux
  kernel 2.6.17, and possibly other versions, allows local users to cause
  a denial of service (oops) by calling setsockopt with the IPV6_RTHDR
  option name and possibly a zero option length or invalid option value,
  which triggers a NULL pointer dereference. (CVE-2007-1388)
  
  net/ipv6/tcp_ipv6.c in Linux kernel 2.4 and 2.6.x up to 2.6.21-rc3
  inadvertently copies the ipv6_fl_socklist from a listening TCP socket
  to child sockets, which allows local users to cause a denial of service
  (OOPS) or double-free by opening a listeing IPv6 socket, attaching a
  flow label, and connecting to that socket. (CVE-2007-1592)
  
  The provided packages are patched to fix these vulnerabilities.
  All users are encouraged to upgrade to these updated kernels immediately
  and reboot to effect the fixes.
  
  In addition to these security fixes, other fixes have been included
  such as:
  
  - Suspend to disk speed improvements
  - Add nmi watchdog support for core2
  - Add atl1 driver
  - Update KVM
  - Add acer_acpi
  - Update asus_acpi
  - Fix suspend on r8169, i8259A
  - Fix suspend when using ondemand governor
  - Add ide acpi support
  - Add suspend/resume support ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00006.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.13mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}