###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for freeradius MDKSA-2007:085 (freeradius)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830072);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:085");
  script_cve_id("CVE-2007-2028");
  script_name(english: "Mandriva Update for freeradius MDKSA-2007:085 (freeradius)");
  desc["english"] = "

  Vulnerability Insight:

  Memory leak in freeRADIUS 1.1.5 and earlier allows remote attackers to
  cause a denial of service (memory consumption) via a large number of
  EAP-TTLS tunnel connections using malformed Diameter format attributes,
  which causes the authentication request to be rejected but does not
  reclaim VALUE_PAIR data structures.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  freeradius on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00021.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of freeradius");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"freeradius", rpm:"freeradius~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1", rpm:"libfreeradius1~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-devel", rpm:"libfreeradius1-devel~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-krb5", rpm:"libfreeradius1-krb5~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-ldap", rpm:"libfreeradius1-ldap~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-mysql", rpm:"libfreeradius1-mysql~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-postgresql", rpm:"libfreeradius1-postgresql~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-unixODBC", rpm:"libfreeradius1-unixODBC~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1", rpm:"lib64freeradius1~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-devel", rpm:"lib64freeradius1-devel~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-krb5", rpm:"lib64freeradius1-krb5~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-ldap", rpm:"lib64freeradius1-ldap~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-mysql", rpm:"lib64freeradius1-mysql~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-postgresql", rpm:"lib64freeradius1-postgresql~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-unixODBC", rpm:"lib64freeradius1-unixODBC~1.1.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"freeradius", rpm:"freeradius~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1", rpm:"libfreeradius1~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-devel", rpm:"libfreeradius1-devel~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-krb5", rpm:"libfreeradius1-krb5~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-ldap", rpm:"libfreeradius1-ldap~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-mysql", rpm:"libfreeradius1-mysql~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-postgresql", rpm:"libfreeradius1-postgresql~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1-unixODBC", rpm:"libfreeradius1-unixODBC~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1", rpm:"lib64freeradius1~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-devel", rpm:"lib64freeradius1-devel~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-krb5", rpm:"lib64freeradius1-krb5~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-ldap", rpm:"lib64freeradius1-ldap~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-mysql", rpm:"lib64freeradius1-mysql~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-postgresql", rpm:"lib64freeradius1-postgresql~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1-unixODBC", rpm:"lib64freeradius1-unixODBC~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}