###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for php MDKSA-2007:102 (php)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830123);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:102");
  script_cve_id("CVE-2007-1864", "CVE-2007-2509", "CVE-2007-2510", "CVE-2007-2511");
  script_name(english: "Mandriva Update for php MDKSA-2007:102 (php)");
  desc["english"] = "

  Vulnerability Insight:

  A heap buffer overflow flaw was found in the xmlrpc extension for PHP.
  A script that implements an XML-RPC server using this extension could
  allow a remote attacker to execute arbitrary code as the apache user.
  This flaw does not, however, affect PHP applications using the pure-PHP
  XML_RPC class provided via PEAR (CVE-2007-1864).
  
  A flaw was found in the ftp extension for PHP.  A script using
  this extension to provide access to a private FTP server and which
  passed untrusted script input directly to any function provided by
  this extension could allow a remote attacker to send arbitrary FTP
  commands to the server (CVE-2007-2509).
  
  A buffer overflow flaw was found in the soap extension for PHP
  in the handling of an HTTP redirect response when using the SOAP
  client provided by the extension with an untrusted SOAP server
  (CVE-2007-2510).
  
  A buffer overflow in the user_filter_factory_create() function has
  unknown impact and local attack vectors (CVE-2007-2511).
  
  Updated packages have been patched to prevent this issue.

  Affected Software/OS:
  php on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00013.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-ftp", rpm:"php-ftp~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.1~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-ftp", rpm:"php-ftp~5.1.6~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.1.6~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.1.6~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.1.6~1.8mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}