###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for koffice MDKSA-2007:163 (koffice)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830011);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:163");
  script_cve_id("CVE-2007-3387");
  script_name(english: "Mandriva Update for koffice MDKSA-2007:163 (koffice)");
  desc["english"] = "

  Vulnerability Insight:

  Maurycy Prodeus found an integer overflow vulnerability in the way
  various PDF viewers processed PDF files.  An attacker could create
  a malicious PDF file that could cause koffice to crash and possibly
  execute arbitrary code open a user opening the file.
  
  This update provides packages which are patched to prevent these
  issues.

  Affected Software/OS:
  koffice on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-08/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of koffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-karbon", rpm:"koffice-karbon~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi", rpm:"koffice-kexi~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kformula", rpm:"koffice-kformula~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kivio", rpm:"koffice-kivio~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-koshell", rpm:"koffice-koshell~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kplato", rpm:"koffice-kplato~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kpresenter", rpm:"koffice-kpresenter~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-krita", rpm:"koffice-krita~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kspread", rpm:"koffice-kspread~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kugar", rpm:"koffice-kugar~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kword", rpm:"koffice-kword~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-progs", rpm:"koffice-progs~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-karbon", rpm:"libkoffice2-karbon~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-karbon-devel", rpm:"libkoffice2-karbon-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kexi", rpm:"libkoffice2-kexi~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kexi-devel", rpm:"libkoffice2-kexi-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kformula", rpm:"libkoffice2-kformula~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kformula-devel", rpm:"libkoffice2-kformula-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kivio", rpm:"libkoffice2-kivio~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kivio-devel", rpm:"libkoffice2-kivio-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-koshell", rpm:"libkoffice2-koshell~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kplato", rpm:"libkoffice2-kplato~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kpresenter", rpm:"libkoffice2-kpresenter~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kpresenter-devel", rpm:"libkoffice2-kpresenter-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-krita", rpm:"libkoffice2-krita~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-krita-devel", rpm:"libkoffice2-krita-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kspread", rpm:"libkoffice2-kspread~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kspread-devel", rpm:"libkoffice2-kspread-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kugar", rpm:"libkoffice2-kugar~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kugar-devel", rpm:"libkoffice2-kugar-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kword", rpm:"libkoffice2-kword~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kword-devel", rpm:"libkoffice2-kword-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-progs", rpm:"libkoffice2-progs~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-progs-devel", rpm:"libkoffice2-progs-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-karbon", rpm:"lib64koffice2-karbon~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-karbon-devel", rpm:"lib64koffice2-karbon-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kexi", rpm:"lib64koffice2-kexi~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kexi-devel", rpm:"lib64koffice2-kexi-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kformula", rpm:"lib64koffice2-kformula~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kformula-devel", rpm:"lib64koffice2-kformula-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kivio", rpm:"lib64koffice2-kivio~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kivio-devel", rpm:"lib64koffice2-kivio-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-koshell", rpm:"lib64koffice2-koshell~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kplato", rpm:"lib64koffice2-kplato~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kpresenter", rpm:"lib64koffice2-kpresenter~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kpresenter-devel", rpm:"lib64koffice2-kpresenter-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-krita", rpm:"lib64koffice2-krita~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-krita-devel", rpm:"lib64koffice2-krita-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kspread", rpm:"lib64koffice2-kspread~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kspread-devel", rpm:"lib64koffice2-kspread-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kugar", rpm:"lib64koffice2-kugar~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kugar-devel", rpm:"lib64koffice2-kugar-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kword", rpm:"lib64koffice2-kword~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kword-devel", rpm:"lib64koffice2-kword-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-progs", rpm:"lib64koffice2-progs~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-progs-devel", rpm:"lib64koffice2-progs-devel~1.6.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-karbon", rpm:"koffice-karbon~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi", rpm:"koffice-kexi~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kformula", rpm:"koffice-kformula~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kivio", rpm:"koffice-kivio~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-koshell", rpm:"koffice-koshell~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kplato", rpm:"koffice-kplato~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kpresenter", rpm:"koffice-kpresenter~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-krita", rpm:"koffice-krita~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kspread", rpm:"koffice-kspread~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kugar", rpm:"koffice-kugar~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kword", rpm:"koffice-kword~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-progs", rpm:"koffice-progs~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-karbon", rpm:"libkoffice2-karbon~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-karbon-devel", rpm:"libkoffice2-karbon-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kexi", rpm:"libkoffice2-kexi~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kexi-devel", rpm:"libkoffice2-kexi-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kformula", rpm:"libkoffice2-kformula~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kformula-devel", rpm:"libkoffice2-kformula-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kivio", rpm:"libkoffice2-kivio~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kivio-devel", rpm:"libkoffice2-kivio-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-koshell", rpm:"libkoffice2-koshell~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kplato", rpm:"libkoffice2-kplato~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kpresenter", rpm:"libkoffice2-kpresenter~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kpresenter-devel", rpm:"libkoffice2-kpresenter-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-krita", rpm:"libkoffice2-krita~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-krita-devel", rpm:"libkoffice2-krita-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kspread", rpm:"libkoffice2-kspread~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kspread-devel", rpm:"libkoffice2-kspread-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kugar", rpm:"libkoffice2-kugar~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kugar-devel", rpm:"libkoffice2-kugar-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kword", rpm:"libkoffice2-kword~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kword-devel", rpm:"libkoffice2-kword-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-progs", rpm:"libkoffice2-progs~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-progs-devel", rpm:"libkoffice2-progs-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-karbon", rpm:"lib64koffice2-karbon~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-karbon-devel", rpm:"lib64koffice2-karbon-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kexi", rpm:"lib64koffice2-kexi~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kexi-devel", rpm:"lib64koffice2-kexi-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kformula", rpm:"lib64koffice2-kformula~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kformula-devel", rpm:"lib64koffice2-kformula-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kivio", rpm:"lib64koffice2-kivio~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kivio-devel", rpm:"lib64koffice2-kivio-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-koshell", rpm:"lib64koffice2-koshell~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kplato", rpm:"lib64koffice2-kplato~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kpresenter", rpm:"lib64koffice2-kpresenter~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kpresenter-devel", rpm:"lib64koffice2-kpresenter-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-krita", rpm:"lib64koffice2-krita~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-krita-devel", rpm:"lib64koffice2-krita-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kspread", rpm:"lib64koffice2-kspread~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kspread-devel", rpm:"lib64koffice2-kspread-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kugar", rpm:"lib64koffice2-kugar~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kugar-devel", rpm:"lib64koffice2-kugar-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kword", rpm:"lib64koffice2-kword~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kword-devel", rpm:"lib64koffice2-kword-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-progs", rpm:"lib64koffice2-progs~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-progs-devel", rpm:"lib64koffice2-progs-devel~1.5.91~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}