###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ghostscript MDKSA-2007:208 (ghostscript)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830025);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:208");
  script_cve_id("CVE-2007-2721");
  script_name(english: "Mandriva Update for ghostscript MDKSA-2007:208 (ghostscript)");
  desc["english"] = "

  Vulnerability Insight:

  A function in the JasPer JPEG-2000 library before 1.900 could allow
  a remote user-assisted attack to cause a crash and possibly corrupt
  the heap via malformed image files.
  
  Newer versions of ghostscript contain an embedded copy of libjasper
  and as such is vulnerable to this issue.
  
  Updated packages have been patched to prevent this issue.

  Affected Software/OS:
  ghostscript on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-X", rpm:"ghostscript-X~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-common", rpm:"ghostscript-common~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-doc", rpm:"ghostscript-doc~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-dvipdf", rpm:"ghostscript-dvipdf~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-module-X", rpm:"ghostscript-module-X~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgs8", rpm:"libgs8~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgs8-devel", rpm:"libgs8-devel~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libijs1", rpm:"libijs1~0.35~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libijs1-devel", rpm:"libijs1-devel~0.35~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gs8", rpm:"lib64gs8~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gs8-devel", rpm:"lib64gs8-devel~8.60~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ijs1", rpm:"lib64ijs1~0.35~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ijs1-devel", rpm:"lib64ijs1-devel~0.35~55.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}