###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for cpio MDKSA-2007:233 (cpio)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830186);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:233");
  script_cve_id("CVE-2007-4476", "CVE-2005-1229");
  script_name(english: "Mandriva Update for cpio MDKSA-2007:233 (cpio)");
  desc["english"] = "

  Vulnerability Insight:

  Buffer overflow in the safer_name_suffix function in GNU cpio
  has unspecified attack vectors and impact, resulting in a crashing
  stack. This problem is originally found in tar, but affects cpio too,
  due to similar code fragments. (CVE-2007-4476)
  
  Directory traversal vulnerability in cpio 2.6 and earlier allows remote
  attackers to write to arbitrary directories via a .. (dot dot) in a
  cpio file. This is an old issue, affecting only Mandriva Corporate
  Server 4 and Mandriva Linux 2007. (CVE-2005-1229)
  
  Updated package fixes these issues.

  Affected Software/OS:
  cpio on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00055.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cpio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.7~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.6~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.9~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}