###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdesdk MDVA-2008:093-1 (kdesdk)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830611);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:093-1");
  script_cve_id("");
  script_name(english: "Mandriva Update for kdesdk MDVA-2008:093-1 (kdesdk)");
  desc["english"] = "

  Vulnerability Insight:

  kdesdk packages in Mandriva Linux 2008 and 2008 Spring had packaging
  bugs which led to the subversion ioslave to not build and thus not
  be provided.
  
  The updated packages fixed the bugs and provide the subversion
  access ioslave.
  
  Update:
  
  The previous kdesdk update placed subversion-related files in such a
  way that they conflicted with kdesvn.  This update corrects that issue.

  Affected Software/OS:
  kdesdk on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00021.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdesdk");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"kdesdk", rpm:"kdesdk~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-cervisia", rpm:"kdesdk-cervisia~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kbabel", rpm:"kdesdk-kbabel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kcachegrind", rpm:"kdesdk-kcachegrind~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kompare", rpm:"kdesdk-kompare~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-po2xml", rpm:"kdesdk-po2xml~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-umbrello", rpm:"kdesdk-umbrello~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1", rpm:"libkdesdk1~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-cervisia", rpm:"libkdesdk1-cervisia~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-cervisia-devel", rpm:"libkdesdk1-cervisia-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-devel", rpm:"libkdesdk1-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-kbabel", rpm:"libkdesdk1-kbabel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-kbabel-devel", rpm:"libkdesdk1-kbabel-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1", rpm:"lib64kdesdk1~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-cervisia", rpm:"lib64kdesdk1-cervisia~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-cervisia-devel", rpm:"lib64kdesdk1-cervisia-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-devel", rpm:"lib64kdesdk1-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-kbabel", rpm:"lib64kdesdk1-kbabel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-kbabel-devel", rpm:"lib64kdesdk1-kbabel-devel~3.5.7~3.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"kdesdk", rpm:"kdesdk~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-cervisia", rpm:"kdesdk-cervisia~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-devel", rpm:"kdesdk-devel~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kbabel", rpm:"kdesdk-kbabel~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kcachegrind", rpm:"kdesdk-kcachegrind~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-kompare", rpm:"kdesdk-kompare~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-po2xml", rpm:"kdesdk-po2xml~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdesdk-umbrello", rpm:"kdesdk-umbrello~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1", rpm:"libkdesdk1~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-cervisia", rpm:"libkdesdk1-cervisia~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesdk1-kbabel", rpm:"libkdesdk1-kbabel~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1", rpm:"lib64kdesdk1~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-cervisia", rpm:"lib64kdesdk1-cervisia~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesdk1-kbabel", rpm:"lib64kdesdk1-kbabel~3.5.9~4.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}