###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for myspell-dictionaries MDVA-2008:107 (myspell-dictionaries)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830682);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:107");
  script_cve_id("");
  script_name(english: "Mandriva Update for myspell-dictionaries MDVA-2008:107 (myspell-dictionaries)");
  desc["english"] = "

  Vulnerability Insight:

  Some thesaurus files of some languages were not properly working
  witn Mandriva Linux 2008.1.  The thesaurus would not bring out the
  meaning and synonym for any searched word for the following languages:
  American English, Spanish, French, German, Polish, Czeck, Slovakian,
  and Hungarian.  This release updates the thesaurus files for these
  languages so that they will work with the Mandriva OpenOffice.org
  version 2.4.1.5.

  Affected Software/OS:
  myspell-dictionaries on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00030.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of myspell-dictionaries");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"myspell-af_ZA", rpm:"myspell-af_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-am_AM", rpm:"myspell-am_AM~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ar_AR", rpm:"myspell-ar_AR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-az_AZ", rpm:"myspell-az_AZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-bg_BG", rpm:"myspell-bg_BG~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-bn_BN", rpm:"myspell-bn_BN~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ca_ES", rpm:"myspell-ca_ES~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-cop_EG", rpm:"myspell-cop_EG~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-csb_CSB", rpm:"myspell-csb_CSB~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-cs_CZ", rpm:"myspell-cs_CZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-cy_GB", rpm:"myspell-cy_GB~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-da_DK", rpm:"myspell-da_DK~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-de_AT", rpm:"myspell-de_AT~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-de_CH", rpm:"myspell-de_CH~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-de_DE", rpm:"myspell-de_DE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-el_GR", rpm:"myspell-el_GR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_AU", rpm:"myspell-en_AU~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_CA", rpm:"myspell-en_CA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_GB", rpm:"myspell-en_GB~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_NZ", rpm:"myspell-en_NZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_US", rpm:"myspell-en_US~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-en_ZA", rpm:"myspell-en_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-eo_EO", rpm:"myspell-eo_EO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-es_ES", rpm:"myspell-es_ES~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-es_MX", rpm:"myspell-es_MX~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-et_EE", rpm:"myspell-et_EE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-eu_ES", rpm:"myspell-eu_ES~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fa_FA", rpm:"myspell-fa_FA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fa_IR", rpm:"myspell-fa_IR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fi_FI", rpm:"myspell-fi_FI~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fj_FJ", rpm:"myspell-fj_FJ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fo_FO", rpm:"myspell-fo_FO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fr_BE", rpm:"myspell-fr_BE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fr_FR", rpm:"myspell-fr_FR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fur_IT", rpm:"myspell-fur_IT~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-fy_NL", rpm:"myspell-fy_NL~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ga_IE", rpm:"myspell-ga_IE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-gd_GB", rpm:"myspell-gd_GB~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-gl_ES", rpm:"myspell-gl_ES~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-gsc_FR", rpm:"myspell-gsc_FR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-he_IL", rpm:"myspell-he_IL~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-hi_IN", rpm:"myspell-hi_IN~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-hr_HR", rpm:"myspell-hr_HR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-hu_HU", rpm:"myspell-hu_HU~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-hy_AM", rpm:"myspell-hy_AM~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-id_ID", rpm:"myspell-id_ID~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-is_IS", rpm:"myspell-is_IS~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-it_IT", rpm:"myspell-it_IT~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-km_KH", rpm:"myspell-km_KH~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ku_TR", rpm:"myspell-ku_TR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-la_LA", rpm:"myspell-la_LA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-lt_LT", rpm:"myspell-lt_LT~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-lv_LV", rpm:"myspell-lv_LV~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-mg_MG", rpm:"myspell-mg_MG~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-mi_NZ", rpm:"myspell-mi_NZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-mn_MN", rpm:"myspell-mn_MN~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-mr_IN", rpm:"myspell-mr_IN~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ms_MY", rpm:"myspell-ms_MY~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-nb_NO", rpm:"myspell-nb_NO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ne_NP", rpm:"myspell-ne_NP~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-nl_NL", rpm:"myspell-nl_NL~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-nn_NO", rpm:"myspell-nn_NO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-nr_ZA", rpm:"myspell-nr_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ns_ZA", rpm:"myspell-ns_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ny_MW", rpm:"myspell-ny_MW~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-oc_FR", rpm:"myspell-oc_FR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-or_OR", rpm:"myspell-or_OR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-pa_PA", rpm:"myspell-pa_PA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-pl_PL", rpm:"myspell-pl_PL~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-pt_BR", rpm:"myspell-pt_BR~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-pt_PT", rpm:"myspell-pt_PT~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-qu_BO", rpm:"myspell-qu_BO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ro_RO", rpm:"myspell-ro_RO~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ru_RU", rpm:"myspell-ru_RU~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-rw_RW", rpm:"myspell-rw_RW~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-sk_SK", rpm:"myspell-sk_SK~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-sl_SI", rpm:"myspell-sl_SI~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ss_ZA", rpm:"myspell-ss_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-st_ZA", rpm:"myspell-st_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-sv_SE", rpm:"myspell-sv_SE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-sw_KE", rpm:"myspell-sw_KE~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-sw_TZ", rpm:"myspell-sw_TZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ta_TA", rpm:"myspell-ta_TA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-tet_ID", rpm:"myspell-tet_ID~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-th_TH", rpm:"myspell-th_TH~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-tl_PH", rpm:"myspell-tl_PH~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-tn_ZA", rpm:"myspell-tn_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ts_ZA", rpm:"myspell-ts_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-uk_UA", rpm:"myspell-uk_UA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-uz_UZ", rpm:"myspell-uz_UZ~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-ve_ZA", rpm:"myspell-ve_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-vi_VI", rpm:"myspell-vi_VI~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-xh_ZA", rpm:"myspell-xh_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-zu_ZA", rpm:"myspell-zu_ZA~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"myspell-dictionaries", rpm:"myspell-dictionaries~1.0.2~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}