###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for evolution MDVSA-2008:111 (evolution)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830584);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:111");
  script_cve_id("CVE-2008-1108", "CVE-2008-1109");
  script_name(english: "Mandriva Update for evolution MDVSA-2008:111 (evolution)");
  desc["english"] = "

  Vulnerability Insight:

  Alan Rad Pop of Secunia Research discovered the following two
  vulnerabilities in Evolution:
  
  Evolution did not properly validate timezone data when processing
  iCalendar attachments.  If a user disabled the Itip Formatter plugin
  and viewed a crafted iCalendar attachment, an attacker could cause
  a denial of service or potentially execute arbitrary code with the
  user's privileges (CVE-2008-1108).
  
  Evolution also did not properly validate the DESCRIPTION field when
  processing iCalendar attachments.  If a user were tricked into
  accepting a crafted iCalendar attachment and replied to it from
  the calendar window, an attacker could cause a denial of service
  or potentially execute arbitrary code with the user's privileges
  (CVE-2008-1109).
  
  In addition, Matej Cepl found that Evolution did not properly validate
  date fields when processing iCalendar attachments, which could lead to
  a denial of service if the user viewed a crafted iCalendar attachment
  with the Itip Formatter plugin disabled.
  
  Mandriva Linux has the Itip Formatter plugin enabled by default.
  
  The updated packages have been patched to prevent these issues.

  Affected Software/OS:
  evolution on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00013.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of evolution");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.12.3~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.12.3~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-mono", rpm:"evolution-mono~2.12.3~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.12.3~1.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.22.0~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.22.0~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-mono", rpm:"evolution-mono~2.22.0~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.22.0~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}