###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for imlib2 MDVSA-2008:123 (imlib2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830638);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:123");
  script_cve_id("CVE-2008-2426");
  script_name(english: "Mandriva Update for imlib2 MDVSA-2008:123 (imlib2)");
  desc["english"] = "

  Vulnerability Insight:

  Stefan Cornelius discovered two buffer overflows in Imlib's image
  loaders for PNM and XPM images, which could possibly result in the
  execution of arbitrary code (CVE-2008-2426).
  
  The updated packages have been patched to prevent this issue.

  Affected Software/OS:
  imlib2 on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00033.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of imlib2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"imlib2-data", rpm:"imlib2-data~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1", rpm:"libimlib2_1~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-devel", rpm:"libimlib2_1-devel~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-filters", rpm:"libimlib2_1-filters~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-loaders", rpm:"libimlib2_1-loaders~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib2", rpm:"imlib2~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1", rpm:"lib64imlib2_1~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-devel", rpm:"lib64imlib2_1-devel~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-filters", rpm:"lib64imlib2_1-filters~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-loaders", rpm:"lib64imlib2_1-loaders~1.2.2~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"imlib2-data", rpm:"imlib2-data~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1", rpm:"libimlib2_1~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-filters", rpm:"libimlib2_1-filters~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-loaders", rpm:"libimlib2_1-loaders~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2-devel", rpm:"libimlib2-devel~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib2", rpm:"imlib2~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1", rpm:"lib64imlib2_1~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-filters", rpm:"lib64imlib2_1-filters~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-loaders", rpm:"lib64imlib2_1-loaders~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2-devel", rpm:"lib64imlib2-devel~1.4.0.003~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"imlib2-data", rpm:"imlib2-data~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1", rpm:"libimlib2_1~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-filters", rpm:"libimlib2_1-filters~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2_1-loaders", rpm:"libimlib2_1-loaders~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libimlib2-devel", rpm:"libimlib2-devel~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imlib2", rpm:"imlib2~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1", rpm:"lib64imlib2_1~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-filters", rpm:"lib64imlib2_1-filters~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2_1-loaders", rpm:"lib64imlib2_1-loaders~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64imlib2-devel", rpm:"lib64imlib2-devel~1.4.0.003~4.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}