###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for cups MDVSA-2008:170 (cups)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830651);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:170");
  script_cve_id("CVE-2008-1722");
  script_name(english: "Mandriva Update for cups MDVSA-2008:170 (cups)");
  desc["english"] = "

  Vulnerability Insight:

  Thomas Pollet discovered an integer overflow vulnerability in the PNG
  image handling filter in CUPS.  This could allow a malicious user to
  execute arbitrary code with the privileges of the user running CUPS,
  or cause a denial of service by sending a specially crafted PNG image
  to the print server (CVE-2008-1722).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  cups on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00013.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.2.10~2.7mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.3.6~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-common", rpm:"cups-common~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-serial", rpm:"cups-serial~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2", rpm:"libcups2~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcups2-devel", rpm:"libcups2-devel~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cups", rpm:"php-cups~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2", rpm:"lib64cups2~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cups2-devel", rpm:"lib64cups2-devel~1.3.6~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}