###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ruby MDVSA-2008:226 (ruby)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830489);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:226");
  script_cve_id("CVE-2008-3443", "CVE-2008-3655", "CVE-2008-3656", "CVE-2008-3657", "CVE-2008-3790", "CVE-2008-3905");
  script_name(english: "Mandriva Update for ruby MDVSA-2008:226 (ruby)");
  desc["english"] = "

  Vulnerability Insight:

  A denial of service condition was found in Ruby's regular expression
  engine.  If a Ruby script tried to process a large amount of data
  via a regular expression, it could cause Ruby to enter an infinite
  loop and crash (CVE-2008-3443).
  
  A number of flaws were found in Ruby that could allow an attacker to
  create a carefully crafted script that could allow for the bypass of
  certain safe-level restrictions (CVE-2008-3655).
  
  A denial of service vulnerability was found in Ruby's HTTP server
  toolkit, WEBrick.  A remote attacker could send a specially-crafted
  HTTP request to a WEBrick server that would cause it to use an
  excessive amount of CPU time (CVE-2008-3656).
  
  An insufficient taintness check issue was found in Ruby's DL module,
  a module that provides direct access to the C language functions.
  This flaw could be used by an attacker to bypass intended safe-level
  restrictions by calling external C functions with the arguments from
  an untrusted tainted input (CVE-2008-3657).
  
  A denial of service condition in Ruby's XML document parsing module
  (REXML) could cause a Ruby application using the REXML module to use
  an excessive amount of CPU and memory via XML documents with large
  XML entitity definitions recursion (CVE-2008-3790).
  
  The Ruby DNS resolver library used predictable transaction IDs and
  a fixed source port when sending DNS requests.  This could be used
  by a remote attacker to spoof a malicious reply to a DNS query
  (CVE-2008-3905).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  ruby on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00002.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.6~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.6~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-doc", rpm:"ruby-doc~1.8.6~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tk", rpm:"ruby-tk~1.8.6~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.6~9p114.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.6~9p114.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-doc", rpm:"ruby-doc~1.8.6~9p114.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tk", rpm:"ruby-tk~1.8.6~9p114.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}