###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libxml2 MDVSA-2008:231 (libxml2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830587);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:231");
  script_cve_id("CVE-2008-4225", "CVE-2008-4226");
  script_name(english: "Mandriva Update for libxml2 MDVSA-2008:231 (libxml2)");
  desc["english"] = "

  Vulnerability Insight:

  Drew Yaro of the Apple Product Security Team found two flaws in
  libxml2.  The first is a denial of service flaw in libxml2's XML
  parser.  If an application linked against libxml2 were to process
  certain malformed XML content, it cause the application to enter an
  infinite loop (CVE-2008-4225).
  
  The second is an integer overflow that caused a heap-based buffer
  overflow in libxml2's XML parser.  If an application linked against
  libxml2 were to process certain malformed XML content, it could
  cause the application to crash or possibly execute arbitrary code
  (CVE-2008-4226).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  libxml2 on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxml2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libxml2_2", rpm:"libxml2_2~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-utils", rpm:"libxml2-utils~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2_2", rpm:"lib64xml2_2~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2-devel", rpm:"lib64xml2-devel~2.6.30~1.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libxml2_2", rpm:"libxml2_2~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-utils", rpm:"libxml2-utils~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2_2", rpm:"lib64xml2_2~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2-devel", rpm:"lib64xml2-devel~2.6.31~1.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libxml2_2", rpm:"libxml2_2~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-utils", rpm:"libxml2-utils~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2_2", rpm:"lib64xml2_2~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2-devel", rpm:"lib64xml2-devel~2.7.1~1.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}