###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_powerpoint_code_exec_vuln.nasl 1397 2009-04-03 14:21:24Z apr $
#
# Microsoft PowerPoint File Parsing Remote Code Execution Vulnerability (967340)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Modified to reflect MS09-017 (Sharath S, 2009-05-13 )
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800382);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0556", "CVE-2009-0220", "CVE-2009-0221", "CVE-2009-0222",
                "CVE-2009-0223", "CVE-2009-0224", "CVE-2009-0225", "CVE-2009-0226",
                "CVE-2009-0227", "CVE-2009-1128", "CVE-2009-1129", "CVE-2009-1130",
                "CVE-2009-1131", "CVE-2009-1137");
  script_bugtraq_id(34351, 34833, 34835, 34831, 34834, 34879, 34880, 34881, 34882,
                    34837, 34839, 34840, 34841, 34876);
  script_name(english:"Microsoft PowerPoint File Parsing Remote Code Execution Vulnerability (967340)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-017.

  Vulnerability Insight:
  For more information about vulnerabilities on PowerPoint, go through the links
  mentioned in references.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes, and can
  cause Memory Corruption, Integer Overflow and other attacks in the context of
  the application through crafting malicious codes inside a powerpoint file.

  Impact Level: System

  Affected Software/OS:
  MS PowerPoint 2000 Service Pack 3 and prior
  MS PowerPoint 2002 Service Pack 3 and prior
  MS PowerPoint 2003 Service Pack 3 and prior
  MS PowerPoint 2007 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-017.mspx

  References:
  http://support.microsoft.com/kb/967340
  http://www.securityfocus.com/archive/1/503451

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Microsoft PowerPoint");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_ms_office_detection_900025.nasl",
                      "secpod_office_products_version_900032.nasl");
  script_require_keys("MS/Office/Ver", "SMB/Office/PowerPnt/Version");
  exit(0);
}


include("version_func.inc");

officeVer = get_kb_item("MS/Office/Ver");
if(officeVer =~ "^(9|10|11|12)\..*")
{
  # Grep for MS Office PowerPoint Version < (9.0.0.8978, 10.0.6853.0 and 11.0.8307.0, 12.0.6500.5000)
  ppVer = get_kb_item("SMB/Office/PowerPnt/Version");
  if(ppVer != NULL)
  {
    if(version_in_range(version:ppVer, test_version:"9.0", test_version2:"9.0.0.8977") ||
       version_in_range(version:ppVer, test_version:"10.0", test_version2:"10.0.6852.0")||
       version_in_range(version:ppVer, test_version:"11.0", test_version2:"11.0.8306.0")||
       version_in_range(version:ppVer, test_version:"12.0", test_version2:"12.0.6500.4999")){
      security_hole(0);
    }
  }
}
