###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_win_live_messenger_detect.nasl 814 2009-01-06 12:01:29Z jan $
#
# Microsoft Windows Live Messenger Client Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800331);
  script_version("$Revision: 1.0 $");
  script_name(english:"Microsoft Windows Live Messenger Client Version Detection");
  desc["english"] = "
  Overview: This script detects the version of Microsoft Windows Live Messenger
  Client on remote host and sets the KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of Windows Live Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\MessengerService\Clients" +
                            "\MSN Messenger")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("Windows Live Messenger" >< registry_get_sz(key:key + item, 
                                                 item:"DisplayName"))
  {
    wlmVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(!wlmVer){
      exit(0);
    }

    set_kb_item(name:"MS/LiveMessenger/Ver", value:wlmVer);
    exit(0);
  }
}
