###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_nullftp_server_detect.nasl 1268 2009-04-01 10:37:24Z apr $
#
# NULL FTP Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800545);
  script_version("$Revision: 1.0 $");
  script_name(english:"NULL FTP Server Version Detection");
  desc["english"] = "
  Overview : This script finds the installed NULL FTP Server version
  and saves the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of NULL FTP Server in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"FTP");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  appName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Null FTP Server" >< appName)
  {
    nullftpVer = eregmatch(pattern:"Null FTP Server ([0-9.]+)", string:appName);
    nullftpVer = nullftpVer[1];
    if(nullftpVer == NULL)
    {
      exePath = registry_get_sz(key:key + item, item:"InstallLocation");
      if(!exePath){
        exit(0);
      }

      exePath = exePath + "NullFtpServer.exe";
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

      nullftpVer = GetVer(file:file, share:share);
    }

    # Set the Version in KB
    if(nullftpVer != NULL){
      set_kb_item(name:"NullFTP/Server/Ver", value:nullftpVer);
    }
  }
}
