###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_nullftp_server_site_cmd_exec_vuln.nasl 1268 2009-04-01 20:10:24Z apr $
#
# Null FTP Server SITE Command Execution Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800546);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6534");
  script_bugtraq_id(32656);
  script_name(english:"Null FTP Server SITE Command Execution Vulnerability");
  desc["english"] = "

  Overview: This host has Null FTP Server installed and is prone to arbitrary
  code execution vulnerability.

  Vulnerability Insight:
  An error is generated while handling custom SITE command containing shell
  metacharacters such as & (ampersand) as a part of an argument.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary codes
  in the context of the application.

  Impact Level: Application

  Affected Software/OS:
  NULL FTP Server Free and Pro version prior to 1.1.0.8 on Windows

  Fix: Upgarde to the latest version 1.1.0.8 or later
  http://www.vwsolutions.com/NullFTPServer/

  References:
  http://secunia.com/advisories/32999
  http://www.milw0rm.com/exploits/7355
  http://xforce.iss.net/xforce/xfdb/47099

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:H/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of NULL FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"FTP");
  script_dependencies("gb_nullftp_server_detect.nasl");
  script_require_keys("NullFTP/Server/Ver");
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

nullPort = get_kb_item("Services/ftp");
if(!nullPort){
  nullPort = 21;
}

if(get_port_state(nullPort))
{
  banner = get_ftp_banner(port:nullPort);
  if("Null FTP Server" >!< banner){
    exit(0);
  }

  ver = get_kb_item("NullFTP/Server/Ver");
  if(!ver){
    exit(0);
  }

  # Grep for version prior to 1.1.0.8
  if(version_is_less(version:ver, test_version:"1.1.0.8")){
    security_hole(nullPort);
  }
}
