###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_detect_lin.nasl 302 2008-10-13 18:59:15Z oct $
#
# Mozilla Seamonkey Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800019);
  script_version("$Revision: 1.1 $");
  script_name(english:"Mozilla SeaMonkey Version Detection (Linux)");
  desc["english"] = "
  Overview : This script finds the Mozilla SeaMonkey installed version on
  Linux and saves the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_family(english:"General");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_summary(english:"Set File Version of Mozilla SeaMonkey in KB");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

seaName = find_file(file_name:"seamonkey", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
if(!seaName){
  seaName = find_file(file_name:"iceape", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
}
foreach binary_seaName (seaName)
{
  binary_name = chomp(binary_seaName);
  seaVer = get_bin_version(full_prog_name:binary_name, version_argv:"-v",
                           ver_pattern:"[0-9].[0-9.]+");
  if(seaVer)
  {
    set_kb_item(name:"Seamonkey/Linux/Ver", value:seaVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
