###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for xine-ui,xine-lib,xine-extra,xine-devel SUSE-SA:2007:013
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850063);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-013");
  script_cve_id("CVE-2007-0017");
  script_name(english: "SuSE Update for xine-ui,xine-lib,xine-extra,xine-devel SUSE-SA:2007:013");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes several format string bugs that can be exploited remotely
  with user-assistance to execute arbitrary code.
  Since SUSE Linux version 10.1 format string bugs are not exploitable
  anymore. CVE-2007-0017

  Impact:
  remote code execution

  Affected Software/OS:
  xine-ui,xine-lib,xine-extra,xine-devel on SUSE LINUX 10.1, openSUSE 10.2, SUSE SLED 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_13_xine.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xine-ui,xine-lib,xine-extra,xine-devel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLED10")
{

  if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.1~24.17", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.1~24.17", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib-32bit", rpm:"xine-lib-32bit~1.1.1~24.17", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui", rpm:"xine-ui~0.99.4~32.14", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"xine-devel", rpm:"xine-devel~1.1.2~40.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.2~40.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.2~40.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui", rpm:"xine-ui~0.99.4~84.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib-32bit", rpm:"xine-lib-32bit~1.1.2~40.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui-32bit", rpm:"xine-ui-32bit~0.99.4~84.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"xine-extra", rpm:"xine-extra~1.1.1~24.17", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.1~24.17", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-ui", rpm:"xine-ui~0.99.4~32.14", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}