###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for samba SUSE-SA:2007:016
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850079);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-016");
  script_cve_id("CVE-2007-0452", "CVE-2007-0453", "CVE-2007-0454");
  script_name(english: "SuSE Update for samba SUSE-SA:2007:016");
  desc["english"] = "

  Vulnerability Insight:

  The Samba daemon was affected by a security problem, where a
  logic error in the deferred open code can lead to an infinite loop
  CVE-2007-0452.

  This problem could be used by remote authenticated attackers that
  have access to the samba daemon.

  Two other problems fixed in the upstream samba security release
  that do not affect the SUSE Samba version:

  - CVE-2007-0454: A format string problem in AFS ACL handling.
  None of our shipping Samba versions have this option compiled in.

  - CVE-2007-0453: A buffer overflow in nss_winbind on Solaris.
  Linux is generally not affected by this problem.

  Impact:
  remote denial of service

  Affected Software/OS:
  samba on SUSE LINUX 10.1, openSUSE 10.2, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_16_samba.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.23d~19.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.22~13.27", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.14", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.14", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.14", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.20b~3.14", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.27", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.27", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.27", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-32bit", rpm:"samba-32bit~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client-32bit", rpm:"samba-client-32bit~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind-32bit", rpm:"samba-winbind-32bit~3.0.22~13.27", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}