###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for XFree86, Xorg SUSE-SA:2007:027
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850113);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-027");
  script_cve_id("CVE-2007-1003", "CVE-2007-1351", "CVE-2007-1352", "CVE-2007-1667");
  script_name(english: "SuSE Update for XFree86, Xorg SUSE-SA:2007:027");
  desc["english"] = "

  Vulnerability Insight:

  Several X security problems were fixed that could be used by local
  attackers to crash the X server or potentially to execute code as
  root user.

  - CVE-2007-1003: Integer overflows in the XC-MISC extension of the
  X-server could potentially be exploited to execute code with root
  privileges.

  - CVE-2007-1667: Integer overflows in libX11 could cause crashes.

  - CVE-2007-1351: Integer overflows in the font handling
  of the X-server could potentially be exploited to execute code with
  root privileges.

  Impact:
  local privilege escalation

  Affected Software/OS:
  XFree86, Xorg on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_27_x.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of XFree86, Xorg");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~7.1~33.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libX11", rpm:"xorg-x11-libX11~7.2~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~7.2~21", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.2~30.6", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libX11-32bit", rpm:"xorg-x11-libX11-32bit~7.2~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~7.2~21", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~6.9.0~50.32.5", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"vnc", rpm:"vnc~3.3.3r2~579", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xloader", rpm:"xloader~4.2.0~284", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmodules", rpm:"xmodules~4.2.0~284", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xshared", rpm:"xshared~4.2.0~284", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xprt", rpm:"XFree86-Xprt~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvnc", rpm:"XFree86-Xvnc~4.3.99.902~43.85", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.0~143", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~143", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xprt", rpm:"XFree86-Xprt~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvnc", rpm:"XFree86-Xvnc~4.3.99.902~43.85", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.0~143", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~143", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xprt", rpm:"XFree86-Xprt~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvnc", rpm:"XFree86-Xvnc~4.3.99.902~43.85", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.0~143", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~143", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xprt", rpm:"XFree86-Xprt~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvnc", rpm:"XFree86-Xvnc~4.3.99.902~43.85", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.0~143", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~143", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xprt", rpm:"xorg-x11-Xprt~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.32.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~6.9.0~50.32.5", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}