###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2007:035
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850056);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-035");
  script_cve_id("CVE-2006-2936", "CVE-2006-5749", "CVE-2006-5753", "CVE-2006-5754", "CVE-2006-5871", "CVE-2006-6106", "CVE-2006-6535", "CVE-2006-7203", "CVE-2007-1353", "CVE-2007-1357", "CVE-2007-1592");
  script_name(english: "SuSE Update for kernel SUSE-SA:2007:035");
  desc["english"] = "

  Vulnerability Insight:

  This kernel update fixes the following security problems in our SUSE
  Linux Enterprise Server 9, Novell Linux Desktop 9 and Open Enterprise
  Server kernels.

  - CVE-2006-2936: The ftdi_sio driver allowed local users to cause a
  denial of service (memory consumption) by writing more data to the
  serial port than the hardware can handle, which causes the data
  to be queued. This requires this driver to be loaded, which only
  happens if such a device is plugged in.

  - CVE-2006-5871: smbfs when UNIX extensions are enabled,
  ignores certain mount options, which could cause clients to use
  server-specified UID, GID and MODE settings.

  - CVE-2006-6106: Multiple buffer overflows in the cmtp_recv_interopmsg
  function in the Bluetooth driver (net/bluetooth/cmtp/capi.c) in the
  Linux kernel allowed remote attackers to cause a denial of service
  (crash) and possibly execute arbitrary code via CAPI messages with
  a large value for the length of the (1) manu (manufacturer) or (2)
  serial (serial number) field.

  - CVE-2006-6535: The dev_queue_xmit function in Linux kernel 2.6 can
  fail before calling the local_bh_disable function, which could
  lead to data corruption and &quot;node lockups&quot;. This issue might not
  be exploitable at all for an attacker.

  - CVE-2006-5749: The isdn_ppp_ccp_reset_alloc_state function in
  drivers/isdn/isdn_ppp.c in the Linux kernel does not call the
  init_timer function for the ISDN PPP CCP reset state timer, which
  has unknown attack vectors and results in a system crash.

  - CVE-2006-5753: Unspecified vulnerability in the listxattr system
  call in Linux kernel, when a &quot;bad inode&quot; is present, allows local
  users to cause a denial of service (data corruption) and possibly
  gain privileges.

  - CVE-2006-5754: The aio_setup_ring function in Linux kernel does not
  properly initialize a variable, which allows local users to cause
  a denial of service (crash).

  - CVE-2007-1357: A denial of service problem against the AppleTalk
  protocol was fixed.  A remote attacker in the same AppleTalk
  network segment could cause the machine to crash if it has AppleTalk
  protocol loaded.

  Please note that we do not load the AppleTalk protocol by default
  and such an attack would only be working within a AppleT ... 

  Description truncated, for more information please check the Reference URL

  Impact:
  remote denial of service

  Affected Software/OS:
  kernel on SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_35_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.22", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.286", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.22", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.286", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.286", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.286", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.286", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.286", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.22", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.286", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}