###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for xpdf, kdegraphics3-pdf, koffice, libextractor, SUSE-SA:2007:060
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850099);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-060");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name(english: "SuSE Update for xpdf, kdegraphics3-pdf, koffice, libextractor, SUSE-SA:2007:060");
  desc["english"] = "

  Vulnerability Insight:

  Secunia Research reported three security bugs in xpdf.
  The first problem occurs while indexing an array in DCTStream::
  readProgressiveDataUnit() and is tracked by CVE-2007-4352. Another method
  in the same class named reset() is vulnerable to an integer overflow which
  leads to an overflow on the heap, CVE-2007-5392. The last bug also causes
  an overflow on the heap but this time in method lookChar() of class
  CCITTFaxStream, CVE-2007-5393.

  All three bugs can be exploited remotely with a crafted PDF file with user-
  assistance only.

  These bugs do not only affect xpdf but also the following packages:
  kdegraphics3-pdf, koffice, libextractor, poppler, gpdf, cups, pdf, pdftohtml

  Impact:
  remote code execution

  Affected Software/OS:
  xpdf, kdegraphics3-pdf, koffice, libextractor, on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_60_pdf.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xpdf, kdegraphics3-pdf, koffice, libextractor,");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database-mysql", rpm:"koffice-database-mysql~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database-psql", rpm:"koffice-database-psql~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-planning", rpm:"koffice-planning~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-python", rpm:"koffice-python~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-ruby", rpm:"koffice-ruby~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.6.3~51.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.12~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.12~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.12~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.12~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.7~60.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-doc", rpm:"poppler-doc~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt4", rpm:"poppler-qt4~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-tools", rpm:"poppler-tools~0.5.4~101.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~19.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.2.12~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.7~12.7", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.7~12.7", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.7~12.7", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.7~12.7", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpdf", rpm:"gpdf~2.10.0~82.4", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database-mysql", rpm:"koffice-database-mysql~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database-psql", rpm:"koffice-database-psql~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-planning", rpm:"koffice-planning~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-python", rpm:"koffice-python~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-ruby", rpm:"koffice-ruby~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.6.0~0.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.5.4~33.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.5.4~33.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.5.4~33.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.5.4~33.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-tools", rpm:"poppler-tools~0.5.4~33.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.5~43.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01~58.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01~58.5", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.2.7~12.7", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01~21.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.00~64.46", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-config", rpm:"xpdf-config~3.00~64.46", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01~21.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.4.4~19.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.4.4~19.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.4.4~19.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.4.4~19.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.1~23.20", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01~21.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.00~64.46", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-config", rpm:"xpdf-config~3.00~64.46", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01~21.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.4.4~19.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.4.4~19.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.4.4~19.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.4.4~19.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.1~23.20", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01~21.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.00~64.46", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-config", rpm:"xpdf-config~3.00~64.46", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01~21.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.4.4~19.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.4.4~19.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.4.4~19.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.4.4~19.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpdf", rpm:"gpdf~2.10.0~40.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdegraphics3-pdf", rpm:"kdegraphics3-pdf~3.5.1~23.20", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-database", rpm:"koffice-database~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-extra", rpm:"koffice-extra~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-illustration", rpm:"koffice-illustration~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-presentation", rpm:"koffice-presentation~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-spreadsheet", rpm:"koffice-spreadsheet~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-wordprocessing", rpm:"koffice-wordprocessing~1.4.2~25.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libextractor", rpm:"libextractor~0.5.10~12.8", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libextractor-devel", rpm:"libextractor-devel~0.5.10~12.8", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pdftohtml", rpm:"pdftohtml~0.36~145.7", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.4.4~19.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.4.4~19.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.4.4~19.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.4.4~19.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.01~21.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.01~21.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.44", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.44", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.44", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.44", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.15~208", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.15~208", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.15~208", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.15~208", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}