###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for postfix SUSE-SA:2008:040
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850031);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-040");
  script_cve_id("CVE-2008-2936", "CVE-2008-2937");
  script_name(english: "SuSE Update for postfix SUSE-SA:2008:040");
  desc["english"] = "

  Vulnerability Insight:

  Postfix is a well known MTA.
  During a source code audit the SuSE Security-Team discovered a local
  privilege escalation bug CVE-2008-2936 as well as a mailbox ownership
  problem CVE-2008-2937 in postfix.
  The first bug allowed local users to execute arbitrary commands as root
  while the second one allowed local users to read other users mail.

  Impact:
  local privilege escalation

  Affected Software/OS:
  postfix on openSUSE 10.2, openSUSE 10.3, openSUSE 11.0, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_40_postfix.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postfix");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.4.5~20.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-devel", rpm:"postfix-devel~2.4.5~20.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.4.5~20.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-postgresql", rpm:"postfix-postgresql~2.4.5~20.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.3.2~32", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-devel", rpm:"postfix-devel~2.3.2~32", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.3.2~32", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-postgresql", rpm:"postfix-postgresql~2.3.2~32", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.26", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.1.1~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.2.9~10.25.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE11.0")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.5.1~28.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-devel", rpm:"postfix-devel~2.5.1~28.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.5.1~28.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-postgresql", rpm:"postfix-postgresql~2.5.1~28.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}