###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for php5 vulnerabilities USN-455-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840068);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "455-1");
  script_cve_id("CVE-2007-1375", "CVE-2007-1376", "CVE-2007-1380", "CVE-2007-1484", "CVE-2007-1521", "CVE-2007-1583", "CVE-2007-1700", "CVE-2007-1718", "CVE-2007-1824", "CVE-2007-1887", "CVE-2007-1888", "CVE-2007-1900");
  script_name(english: "Ubuntu Update for php5 vulnerabilities USN-455-1");
  desc["english"] = "

  Vulnerability Insight:

  Stefan Esser discovered multiple vulnerabilities in the &quot;Month of PHP
  bugs&quot;.
  
  The substr_compare() function did not sufficiently verify its length
  argument. This might be exploited to read otherwise unaccessible
  memory, which might lead to information disclosure. (CVE-2007-1375)
  
  The shared memory (shmop) functions did not verify resource types,
  thus they could be called with a wrong resource type that might
  contain user supplied data. This could be exploited to read and write
  arbitrary memory addresses of the PHP interpreter.  This issue does
  not affect Ubuntu 7.04. (CVE-2007-1376)
  
  The php_binary handler of the session extension was missing a boundary
  check. When unserializing overly long variable names this could be
  exploited to read up to 126 bytes of memory, which might lead to
  information disclosure. (CVE-2007-1380)
  
  The internal array_user_key_compare() function, as used for example by
  the PHP function uksort(), incorrectly handled memory unreferencing of
  its arguments. This could have been exploited to execute arbitrary
  code with the privileges of the PHP interpreter, and thus
  circumventing any disable_functions, open_basedir, or safe_mode
  restrictions. (CVE-2007-1484)
  
  The session_regenerate_id() function did not properly clean up the
  former session identifier variable. This could be exploited to crash
  the PHP interpreter, possibly also remotely. (CVE-2007-1521)
  
  Under certain conditions the mb_parse_str() could cause the
  register_globals configuration option to become permanently enabled.
  This opened an attack vector for a large and common class of
  vulnerabilities. (CVE-2007-1583)
  
  The session extension did not set the correct reference count value
  for the session variables. By unsetting _SESSION and HTTP_SESSION_VARS
  (or tricking a PHP script into doing that) this could be exploited to
  execute arbitrary code with the privileges of the PHP interpreter. This
  issue does not affect Ubuntu 7.04.  (CVE-2007-1700)
  
  The mail() function did not correctly escape control characters in
  multiline email headers. This could be remotely exploited to inject
  arbitrary email headers. (CVE-2007-1718)
  
  The php_stream_filter_create() function had an off-by-one buffer
  overflow in the handling of wildcards. This could be exploited to
  remotely crash the PHP interpreter. This issue does not affect Ubuntu
  7.04. (CVE-2007-1824)
  
  When calling the  sqlite_udf_decode_binary() with special arguments, a
  buffer overflow happened. Depending on the application t ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  php5 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-April/000523.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.1.2-1ubuntu3.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.1.6-1ubuntu2.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}