###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for fetchmail vulnerabilities USN-520-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840065);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "520-1");
  script_cve_id("CVE-2007-1558", "CVE-2007-4565");
  script_name(english: "Ubuntu Update for fetchmail vulnerabilities USN-520-1");
  desc["english"] = "

  Vulnerability Insight:

  Gaetan Leurent discovered a vulnerability in the APOP protocol based
  on MD5 collisions. As fetchmail supports the APOP protocol, this
  vulnerability can be used by attackers to discover a portion of the APOP
  user's authentication credentials. (CVE-2007-1558)
  
  Earl Chew discovered that fetchmail can be made to de-reference a NULL
  pointer when contacting SMTP servers. This vulnerability can be used
  by attackers who control the SMTP server to crash fetchmail and cause
  a denial of service. (CVE-2007-4565)

  Affected Software/OS:
  fetchmail vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-September/000597.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of fetchmail vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.6-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.6-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.2-2ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.2-2ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.4-1ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.4-1ubuntu4.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}