###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dovecot vulnerabilities USN-593-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840335);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "593-1");
  script_cve_id("CVE-2008-1199", "CVE-2008-1218");
  script_name(english: "Ubuntu Update for dovecot vulnerabilities USN-593-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that the default configuration of dovecot could allow
  access to any email files with group &quot;mail&quot; without verifying that a user
  had valid rights.  An attacker able to create symlinks in their mail
  directory could exploit this to read or delete another user's email.
  (CVE-2008-1199)
  
  By default, dovecot passed special characters to the underlying
  authentication systems.  While Ubuntu releases of dovecot are not known
  to be vulnerable, the authentication routine was proactively improved
  to avoid potential future problems.  (CVE-2008-1218)

  Affected Software/OS:
  dovecot vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-March/000682.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dovecot vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.rc17-1ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.rc17-1ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.rc17-1ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.beta3-3ubuntu5.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.beta3-3ubuntu5.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.beta3-3ubuntu5.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.rc2-1ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.rc2-1ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.rc2-1ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.5-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.5-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.5-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}