###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox vulnerabilities USN-602-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840215);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "602-1");
  script_cve_id("CVE-2008-1380");
  script_name(english: "Ubuntu Update for firefox vulnerabilities USN-602-1");
  desc["english"] = "

  Vulnerability Insight:

  Flaws were discovered in Firefox which could lead to crashes during
  JavaScript garbage collection. If a user were tricked into opening a
  malicious web page, an attacker may be able to crash the browser or
  possibly execute arbitrary code with the user's privileges.
  (CVE-2008-1380)

  Affected Software/OS:
  firefox vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-April/000695.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.14+1nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080417a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.14+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.14+2nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}