###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux, linux-source-2.6.15/20/22 vulnerabilities USN-637-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840325);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "637-1");
  script_cve_id("CVE-2008-2812", "CVE-2008-2931", "CVE-2008-3272", "CVE-2008-3275", "CVE-2008-0598");
  script_name(english: "Ubuntu Update for linux, linux-source-2.6.15/20/22 vulnerabilities USN-637-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that there were multiple NULL-pointer function
  dereferences in the Linux kernel terminal handling code. A local attacker
  could exploit this to execute arbitrary code as root, or crash the system,
  leading to a denial of service. (CVE-2008-2812)
  
  The do_change_type routine did not correctly validation administrative
  users. A local attacker could exploit this to block mount points or cause
  private mounts to be shared, leading to denial of service or a possible
  loss of privacy. (CVE-2008-2931)
  
  Tobias Klein discovered that the OSS interface through ALSA did not
  correctly validate the device number. A local attacker could exploit this
  to access sensitive kernel memory, leading to a denial of service or a loss
  of privacy. (CVE-2008-3272)
  
  Zoltan Sogor discovered that new directory entries could be added to
  already deleted directories. A local attacker could exploit this, filling
  up available memory and disk space, leading to a denial of service.
  (CVE-2008-3275)
  
  In certain situations, the fix for CVE-2008-0598 from USN-623-1 was causing
  infinite loops in the writev syscall.  This update corrects the mistake.  We
  apologize for the inconvenience.

  Affected Software/OS:
  linux, linux-source-2.6.15/20/22 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/000742.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of linux, linux-source-2.6.15/20/22 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52-386_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52-686_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52-k7_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52-server-bigiron_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52-server_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-52_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-52-386_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-52-686_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-52-k7_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-52-server-bigiron_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-52-server_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15_2.6.15-52.71", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17-386_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17-generic_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17-lowlatency_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17-server-bigiron_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17-server_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.20-17_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.20-17-386_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.20-17-generic_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.20-17-server-bigiron_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.20-17-server_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.20-17-386_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.20-17-generic_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.20-17-server-bigiron_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.20-17-server_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.20-17-lowlatency_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.20-17-lowlatency_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.20_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.20_2.6.20-17.39", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-386_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-generic_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-openvz_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-rt_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-server_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-virtual_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19-xen_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-386_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-generic_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-server_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-virtual_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-19-386_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-19-generic_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-19-server_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-19-virtual_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-openvz_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-rt_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-19-xen_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.24_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-19_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.24_2.6.24-19.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-386_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-generic_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-rt_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-server_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-ume_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-virtual_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15-xen_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-386_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-generic_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-server_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-virtual_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.22-15-386_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.22-15-generic_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.22-15-server_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.22-15-virtual_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-rt_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-ume_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.22-15-xen_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.22_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.22-15_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.22_2.6.22-15.58", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}