###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for nasm vulnerability USN-648-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840282);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "648-1");
  script_cve_id("CVE-2008-2719");
  script_name(english: "Ubuntu Update for nasm vulnerability USN-648-1");
  desc["english"] = "

  Vulnerability Insight:

  Philipp Thomas discovered that the ppscan function of nasm contained
  an off-by-one error.  If a user or automated system were tricked into
  assembling a specially crafted ASM file, a remote attacker could execute
  arbitrary commands with user privileges.

  Affected Software/OS:
  nasm vulnerability on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/000756.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nasm vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"nasm", ver:"0.99.06-2ubuntu0.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}