###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for lcms vulnerability USN-652-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840254);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "652-1");
  script_cve_id("CVE-2007-2741");
  script_name(english: "Ubuntu Update for lcms vulnerability USN-652-1");
  desc["english"] = "

  Vulnerability Insight:

  Chris Evans discovered that certain ICC operations in lcms were not
  correctly bounds-checked.  If a user or automated system were tricked
  into processing an image with malicious ICC tags, a remote attacker could
  crash applications linked against liblcms1, leading to a denial of service,
  or possibly execute arbitrary code with user privileges.

  Affected Software/OS:
  lcms vulnerability on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/000760.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of lcms vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.13-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"liblcms1", ver:"1.13-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.13-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}