###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dovecot vulnerability USN-666-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840234);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "666-1");
  script_cve_id("CVE-2008-4907");
  script_name(english: "Ubuntu Update for dovecot vulnerability USN-666-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that certain email headers were not correctly handled
  by Dovecot.  If a remote attacker sent a specially crafted email to a
  user with a mailbox managed by Dovecot, that user's mailbox would become
  inaccessible through Dovecot, leading to a denial of service.

  Affected Software/OS:
  dovecot vulnerability on Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000775.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dovecot vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"dovecot-common", ver:"1.1.4-0ubuntu1.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-dev", ver:"1.1.4-0ubuntu1.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.1.4-0ubuntu1.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.1.4-0ubuntu1.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}