###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for avahi vulnerabilities USN-696-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840302);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "696-1");
  script_cve_id("CVE-2007-3372", "CVE-2008-5081");
  script_name(english: "Ubuntu Update for avahi vulnerabilities USN-696-1");
  desc["english"] = "

  Vulnerability Insight:

  Emanuele Aina discovered that Avahi did not properly validate it's input when
  processing data over D-Bus. A local attacker could send an empty TXT message
  via D-Bus and cause a denial of service (failed assertion). This issue only
  affected Ubuntu 6.06 LTS. (CVE-2007-3372)
  
  Hugo Dias discovered that Avahi did not properly verify it's input when
  processing mDNS packets. A remote attacker could send a crafted mDNS packet
  and cause a denial of service (assertion failure). (CVE-2008-5081)

  Affected Software/OS:
  avahi vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000810.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of avahi vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core4", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-cil", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"monodoc-avahi-manual", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-avahi", ver:"0.6.10-0ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"avahi-autoipd", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dbg", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core5", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-gobject-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-gobject0", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-1", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui0", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-ui-utils", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-avahi", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.23-2ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"avahi-autoipd", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dbg", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core5", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-gobject-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-gobject0", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-1", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui-dev", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui0", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-avahi", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.22-2ubuntu4.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"avahi-autoipd", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-daemon", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-client3", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-data", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-common3", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-howl0", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-compat-libdnssd1", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-core5", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-glib1", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-1", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt3-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-1", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-qt4-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui-dev", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libavahi-ui0", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-dnsconfd", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-utils", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avahi-discover", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-avahi", ver:"0.6.20-2ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}