##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ultraiso_detect.nasl 1559 2009-04-08 13:10:24Z apr $
#
# UltraISO Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800274);
  script_version("$Revision: 1.0 $");
  script_name(english:"UltraISO Version Detection");
  desc["english"] = "
  Overview : This script detects the installed version of UltraISO and
  sets the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of UltraISO in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  ultraName = registry_get_sz(key:key + item, item:"DisplayName");
  if("UltraISO" >< ultraName)
  {
    path = registry_get_sz(key:key + item, item:"DisplayIcon");
    if(path == NULL){
       continue;
    }

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);

    soc = open_sock_tcp(port);
    if(!soc){
      exit(0);
    }

    r = smb_session_request(soc:soc, remote:name);
    if(!r)
    {
      close(soc);
      exit(0);
    }

    prot = smb_neg_prot(soc:soc);
    if(!prot)
    {
      close(soc);
      exit(0);
    }

    r = smb_session_setup(soc:soc, login:login, password:pass,
                          domain:domain, prot:prot);
    if(!r)
    {
      close(soc);
      exit(0);
    }

    uid = session_extract_uid(reply:r);
    r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

    tid = tconx_extract_tid(reply:r);
    if(!tid)
    {
      close(soc);
      exit(0);
    }

    fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
    if(!fid)
    {
      close(soc);
      exit(0);
    }

    v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:1174636);
    close(soc);
    if(v != NULL){
      set_kb_item(name:"UltraISO/Ver", value:v);
    }
    exit(0);
  }
}
