#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90021);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-1382");
 name["english"] = "libpng vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probably affected by the vulnerabilities described in
CVE-2008-1382

Impact
      libpng 1.0.6 through 1.0.32, 1.2.0 through 1.2.26,
      and 1.4.0beta01 through 1.4.0beta19 allows context-dependent
      attackers to cause a denial of service (crash) and possibly
      execute arbitrary code via a PNG file with zero length
      unknown chunks, which trigger an access of uninitialized
      memory. 

References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1382

Solution:
    All users should upgrade to the latest libpng version of their Linux Distribution.


Risk factor : High
";

 script_description(english:desc["english"]);
 summary["english"] = "Determines the Version of libpng";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Local test";
 script_family(english:family["english"]);
 script_dependencies("ssh_authorization.nasl");
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");

local_var sec_proto, r;

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

sec_proto = "libpng";
r = find_bin(prog_name:"libpng-config", sock:sock);
foreach binary_name (r) {
  binary_name = chomp(binary_name);
  ver = get_bin_version(full_prog_name:binary_name, version_argv:"--version", ver_pattern:"([0-9\.]+)");
  if(ver != NULL) {
    if(version_is_less(version:ver[0], test_version:"1.0.32") ) {
      security_warning(port:0, proto:sec_proto);
      report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
      security_warning(port:0, proto:sec_proto, data:report);
    } else {
      if(version_is_greater_equal(version:ver[0], test_version:"1.2.0") &&
         version_is_less(version:ver[0], test_version:"1.2.27") ) {
        security_warning(port:0, proto:sec_proto);
        report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
        security_warning(port:0, proto:sec_proto, data:report);
      } else {
        if(version_is_equal(version:ver[0], test_version:"1.4.0") ) {
          ver = get_bin_version(full_prog_name:binary_name, version_argv:"--version", ver_pattern:"(beta..)");
          if(ver != NULL) {
            if(version_is_greater_equal(version:ver[0], test_version:"beta01") && 
               version_is_less(version:ver[0], test_version:"beta20") ) {
              security_warning(port:0, proto:sec_proto);
              report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
              security_warning(port:0, proto:sec_proto, data:report);
            }
          }
        }
      }
    }
  }
}

exit(0);
