# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:069 (curl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63519);
 script_cve_id("CVE-2009-0037");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:069 (curl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to curl
announced via advisory MDVSA-2009:069.

A security vulnerability has been identified and fixed in curl, which
could allow remote HTTP servers to (1) trigger arbitrary requests to
intranet servers, (2) read or overwrite arbitrary files via a redirect
to a file: URL, or (3) execute arbitrary commands via a redirect to
an scp: URL (CVE-2009-0037).

The updated packages have been patched to prevent this.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0,
          Multi Network Firewall 2.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:069

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:069 (curl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"curl", rpm:"curl~7.16.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.16.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.16.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl4", rpm:"lib64curl4~7.16.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl-devel", rpm:"lib64curl-devel~7.16.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-examples", rpm:"curl-examples~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl4", rpm:"lib64curl4~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl-devel", rpm:"lib64curl-devel~7.18.0~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-examples", rpm:"curl-examples~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl4", rpm:"lib64curl4~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl-devel", rpm:"lib64curl-devel~7.19.0~2.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.11.0~2.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl2", rpm:"libcurl2~7.11.0~2.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl2-devel", rpm:"libcurl2-devel~7.11.0~2.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl2", rpm:"lib64curl2~7.11.0~2.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl2-devel", rpm:"lib64curl2-devel~7.11.0~2.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.14.0~2.3.20060mdk", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl3", rpm:"libcurl3~7.14.0~2.3.20060mdk", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl3-devel", rpm:"libcurl3-devel~7.14.0~2.3.20060mdk", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl3", rpm:"lib64curl3~7.14.0~2.3.20060mdk", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64curl3-devel", rpm:"lib64curl3-devel~7.14.0~2.3.20060mdk", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.11.0~2.3.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl2", rpm:"libcurl2~7.11.0~2.3.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl2-devel", rpm:"libcurl2-devel~7.11.0~2.3.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
