# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:072 (perl-MDK-Common)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63523);
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:072 (perl-MDK-Common)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to perl-MDK-Common
announced via advisory MDVSA-2009:072.

Some vulnerabilities were discovered and corrected in perl-MDK-Common:

The functions used to write strings into shell like configuration files
by Mandriva tools were not taking care of some special characters. This
could lead to some bugs (like wireless keys containing certain
characters not working), and privilege escalation. This update fixes
that issue by ensuring proper protection of strings.

The updated packages have been patched to correct these issues.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0,
          Multi Network Firewall 2.0


Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:072

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:072 (perl-MDK-Common)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.2.9~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.2.12~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.2.14~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.1.11~3.1.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common-devel", rpm:"perl-MDK-Common-devel~1.1.11~3.1.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.1.24~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common-devel", rpm:"perl-MDK-Common-devel~1.1.24~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common", rpm:"perl-MDK-Common~1.1.11~3.1.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-MDK-Common-devel", rpm:"perl-MDK-Common-devel~1.1.11~3.1.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
