# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:086 (gstreamer-plugins)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63719);
 script_cve_id("CVE-2009-0398");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:086 (gstreamer-plugins)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gstreamer-plugins
announced via advisory MDVSA-2009:086.

An array indexing error in the GStreamer's QuickTime media file
format decoding plug-in enables attackers to crash the application
and potentially execute arbitrary code by using a crafted media file
(CVE-2009-0398).

This update provides fix for that security issue.

Affected: Corporate 3.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:086

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:086 (gstreamer-plugins)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gstreamer-a52dec", rpm:"gstreamer-a52dec~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-aalib", rpm:"gstreamer-aalib~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-arts", rpm:"gstreamer-arts~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-artsd", rpm:"gstreamer-artsd~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-audio-effects", rpm:"gstreamer-audio-effects~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-audiofile", rpm:"gstreamer-audiofile~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-audio-formats", rpm:"gstreamer-audio-formats~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-avi", rpm:"gstreamer-avi~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-cdparanoia", rpm:"gstreamer-cdparanoia~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-cdplayer", rpm:"gstreamer-cdplayer~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-colorspace", rpm:"gstreamer-colorspace~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-dv", rpm:"gstreamer-dv~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-dxr3", rpm:"gstreamer-dxr3~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-esound", rpm:"gstreamer-esound~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-festival", rpm:"gstreamer-festival~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-ffmpeg", rpm:"gstreamer-ffmpeg~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-flac", rpm:"gstreamer-flac~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-flx", rpm:"gstreamer-flx~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-GConf", rpm:"gstreamer-GConf~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-gnomevfs", rpm:"gstreamer-gnomevfs~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-gsm", rpm:"gstreamer-gsm~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-httpsrc", rpm:"gstreamer-httpsrc~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-jack", rpm:"gstreamer-jack~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-jpeg", rpm:"gstreamer-jpeg~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-jpegmmx", rpm:"gstreamer-jpegmmx~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-ladspa", rpm:"gstreamer-ladspa~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-libdvdnav", rpm:"gstreamer-libdvdnav~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-libdvdread", rpm:"gstreamer-libdvdread~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-libpng", rpm:"gstreamer-libpng~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-mad", rpm:"gstreamer-mad~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-mikmod", rpm:"gstreamer-mikmod~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-mpeg", rpm:"gstreamer-mpeg~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-oss", rpm:"gstreamer-oss~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-plugins", rpm:"gstreamer-plugins~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-plugins-devel", rpm:"gstreamer-plugins-devel~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-qcam", rpm:"gstreamer-qcam~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-quicktime", rpm:"gstreamer-quicktime~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-raw1394", rpm:"gstreamer-raw1394~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-SDL", rpm:"gstreamer-SDL~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-sid", rpm:"gstreamer-sid~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-snapshot", rpm:"gstreamer-snapshot~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-swfdec", rpm:"gstreamer-swfdec~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-udp", rpm:"gstreamer-udp~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-v4l", rpm:"gstreamer-v4l~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-vcd", rpm:"gstreamer-vcd~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-video-effects", rpm:"gstreamer-video-effects~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-videosink", rpm:"gstreamer-videosink~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-videotest", rpm:"gstreamer-videotest~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-visualisation", rpm:"gstreamer-visualisation~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-vorbis", rpm:"gstreamer-vorbis~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-xvideosink", rpm:"gstreamer-xvideosink~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-yuv4mjpeg", rpm:"gstreamer-yuv4mjpeg~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstgconf0.6", rpm:"libgstgconf0.6~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstplay0.6", rpm:"libgstplay0.6~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstgconf0.6", rpm:"lib64gstgconf0.6~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstplay0.6", rpm:"lib64gstplay0.6~0.6.4~4.2mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
