#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread")) exit(0);

if(description)
{
 script_id(14260);
 script_version ("1.6");
 name["english"] = "Nikto (NASL wrapper)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin uses nikto(1) to find weak CGI scripts
and other known issues regarding web server security.
See the preferences section for configuration options.

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Assess web server security with Nikto";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencies("find_service.nes", "httpver.nasl", "logins.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

 script_add_preference(name:"Force scan even without 404s",
                       type:"checkbox", value:"no");
 exit(0);
}

if (! defined_func("pread"))
{
  set_kb_item(name: "/tmp/UnableToRun/14254", value: TRUE);
  display("Script #14254 (nikto_wrapper) cannot run\n");
  exit(0);
}

nikto = "";

if (  find_in_path("nikto.pl")  )
{
	nikto = "nikto.pl";
}
else if (  find_in_path("nikto")  )
{
	nikto = "nikto";	
}
else
{
    text = 'Nikto could not be found in your system path.\n';
    text += 'OpenVAS was unable to execute Nikto and to perform the scan you
requested.\nPlease make sure that Nikto is installed and that nikto.pl or nikto is
available in the PATH variable defined for your environment.';
    security_note(port: port, data: text);
    exit(0);
}

user = get_kb_item("http/login");
pass = get_kb_item("http/login");
ids = get_kb_item("/Settings/Whisker/NIDS");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

# Nikto will generate many false positives if the web server is broken
no404 = get_kb_item("www/no404/" + port);
if ( no404 )
{
  text = 'The target server did not return 404 on requests for non-existent pages.\n';
  p = script_get_preference("Force scan even without 404s");
  if ("no" >< p)
  {
    text += 'This scan has not been executed since Nikto is prone to reporting many false positives in this case.\n';
    text += 'If you wish to force this scan, you can enable it in the Nikto preferences in your client.\n';
    security_note(port: port, data: text);
    exit(0);
  }
  else
  {
    text += 'You have requested to force this scan. Please be aware that Nikto is very likely to report false\n';
    text += 'positives under these circumstances. You need to check whether the issues reported by Nikto are\n';
    text += 'real threats or were caused by otherwise correct configuration on the target server.\n';
    security_note(port: port, data: text);
  }
}

i = 0;
argv[i++] = nikto;

httpver = get_kb_item("http/"+port);
if (httpver == "11")
{
  argv[i++] = "-vhost";
  argv[i++] = get_host_name();
}

argv[i++] = "-h"; argv[i++] = get_host_ip();
argv[i++] = "-p"; argv[i++] = port;

encaps = get_port_transport(port);
if (encaps > 1) argv[i++] = "-ssl";

if (idx && idx != "X")
{
  argv[i++] = "-evasion";
  argv[i++] = ids[0];
}

if (user)
{
  if (pass)
    s = strcat(user, ':', pass);
  else
    s = user;
  argv[i++] = "-id";
  argv[i++] = s;
}

r = pread(cmd: nikto, argv: argv, cd: 1);
if (! r) exit(0);	# error

report = 'Here is the Nikto report:\n';
foreach l (split(r))
{
  display(j ++, "\n");
  l = ereg_replace(string: l, pattern: '^[ \t]+', replace: '');
  if (l[0] == '+' || l[0] == '-' || ! match(pattern: "ERROR*", string: l))
    report += l;
}

security_note(port: port, data: report);
