#CESA-2009:0008 63181 2
# $Id$
# Description: Auto-generated from advisory CESA-2009:0008 (dbus)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63181);
 script_cve_id("CVE-2008-3834");
 script_version ("$");
 name["english"] = "CentOS Security Advisory CESA-2009:0008 (dbus)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to dbus announced in
advisory CESA-2009:0008.

For details on the issues addressed in this update,
please visit the referenced security advisories.

Solution:
Update the appropriate packages on your system.

http://www.securityspace.com/smysecure/catid.html?in=CESA-2009:0008
http://www.securityspace.com/smysecure/catid.html?in=RHSA-2009:0008
https://rhn.redhat.com/errata/RHSA-2009-0008.html

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "CentOS Security Advisory CESA-2009:0008 (dbus)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "CentOS Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dbus", rpm:"dbus~1.0.0~7.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-devel", rpm:"dbus-devel~1.0.0~7.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~1.0.0~7.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
