##############################################################################
#
#  Chilkat Crypt ActiveX Control 'ChilkatCrypt2.dll' File Overwrite Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/05
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0435
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900171);
  script_bugtraq_id(32073);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"Chilkat Crypt ActiveX Control 'ChilkatCrypt2.dll' File Overwrite Vulnerability");
  script_summary(english:"Check for vulnerable version of Chilkat Crypt");
  desc["english"] = "

  Overview: The host is installed Chilkat Crypt, which is prone to ActiveX 
  Control based arbitrary file overwrite vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to the error in the 'ChilkatCrypt2.dll' ActiveX
  Control component that does not restrict access to the 'WriteFile()' method.

  Impact:
  Successful exploitation will allow execution of arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  Chilkat Crypt ActiveX Component version 4.3.2.1 and prior
 
  Fix: Set the kill-bit for the CLSID {3352B5B9-82E8-4FFD-9EB1-1A3E60056904}.
  No solution/patch is available as on 05th November, 2008.

  References:
  http://milw0rm.com/exploits/6963
  http://secunia.com/advisories/32513/

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 7.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
enumKeys = registry_enum_keys(key);

if(!enumKeys){
  exit(0);
}

foreach entry (enumKeys)
{
  if("Chilkat Crypt ActiveX" ><
     registry_get_sz(key: key + entry, item:"DisplayName"))
  {
    # Grep for version 4.3.2.1 and prior
    if(egrep(pattern:"^4\.([0-2](\..*)?|3(\.[0-2](\.[01])?)?)$",
             string:registry_get_sz(key: key + entry, item:"DisplayVersion")))
    {
      # Check if Kill-Bit is set for ActiveX control
      clsid = "{3352B5B9-82E8-4FFD-9EB1-1A3E60056904}";
      regKey = "SOFTWARE\Classes\CLSID\" + clsid;
      if(registry_key_exists(key:regKey))
      {
        activeKey = "SOFTWARE\Microsoft\Internet Explorer\" +
                    "ActiveX Compatibility\" + clsid;
        killBit = registry_get_dword(key:activeKey, item:"Compatibility Flags");
        if(killBit && (int(killBit) == 1024)){
          exit(0);
        }
        security_warning(0);
      }
    }
    exit(0);
  }
}
