##############################################################################
#
#  Hummingbird HostExplorer ActiveX Control BOF Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/20
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0354
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900159);
  script_bugtraq_id(31783);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"Hummingbird HostExplorer ActiveX Control BOF Vulnerability");
  script_summary(english:"Check for vulnerable version of Hummingbird HostExplorer ActiveX Control");
  desc["english"] = "
  Overview: This host has Hummingbird HostExplorer ActiveX Control installed
  and is prone to stack based buffer overflow vulnerability.

  The flaw is due to error in Hummingbird.XWebHostCtrl.1 ActiveX control in
  hclxweb.dll file when handling the 'PlainTextPassword' function, which can
  be exploited by assigning an overly long string.

  Impact:
  Successful exploitation will allow execution arbitrary code, and deny the
  service.

  Impact Level: Application 

  Affected Software/OS:
  Hummingbird HostExplorer versions prior to 2008 on Windows (all)

  Fix: Update to HostExplorer 2008
  http://connectivity.hummingbird.com/products/nc/he/index.html

  References:
  http://milw0rm.com/exploits/6761
  http://secunia.com/advisories/32319/

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C) 
    CVSS Temporal Score : 6.5
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

hostExpVer = registry_get_sz(key:"SOFTWARE\Hummingbird\Event Monitoring" +
                                 "\Product Info\HostExplorer 2008" ,
                             item:"Version");
if(!hostExpVer){
  hostExpVer = registry_get_sz(key:"SOFTWARE\Hummingbird\Event Monitoring" +
                                   "\Product Info\HostExplorer 2008\HostExplorer",
                               item:"Version");
  if(!hostExpVer){
    exit(0);
  }
}

# Grep for HostExplorer 2008 version < 13.0.0.0
if(ereg(pattern:"^(([0-9]|1[0-2])(\..*)?)($|[^.0-9])", string:hostExpVer)){
  security_hole(0);
}
