##############################################################################
#
#  Microsoft Windows Media Player Version Detection
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/06
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0437
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900173);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"General");
  script_name(english:"Microsoft Windows Media Player Version Detection");
  script_summary(english:"Set File Version of Windows Media Player in KB");
  desc["english"] = "
  Overview : This script find the Windows Media Player installed version and 
  save the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

keyX = "SOFTWARE\Microsoft\Active setup\Installed Components\";
 
# CLSID matchs with Win Media Player versions 7 or above
wmpVer = registry_get_sz(key:keyX + "{6BF52A52-394A-11d3-B153-00C04F79FAA6}",
                         item:"Version");
if(!wmpVer)
{
  wmpVer = registry_get_sz(key:keyX + "{22d6f312-b0f6-11d0-94ab-0080c74c7e95}",
                           item:"Version");
  if(!wmpVer){
    exit(0);
  }
}

# For replacing comma (,) with dot (.)
wmpVer = ereg_replace(string:wmpVer, pattern:",", replace:".");

# Set the KB item for Windows Media Player.
set_kb_item(name:"Win/MediaPlayer/Ver", value:wmpVer);
